<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductionOrder extends Model
{
    use HasFactory;

    // create fillable array
    protected $fillable = [
        'selling_id',
        'customer_id',
        'account_id',
        'date',
        'total',
        'type',
        'genre',
        'paid',
        'due',
    ];

    // create relationship with debts
    public function debts()
    {
        return $this->hasMany(Debts::class);
    }

    // create relationship with production order
    public function items()
    {
        return $this->hasMany(ProductionOrderItem::class);
    }

    // create relationship with location
    public function selling()
    {
        return $this->belongsTo(selling::class);
    }

    // create relationship with product
    public function account()
    {
        return $this->belongsTo(Account::class);
    }

    // create relationship with customer
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    // create relationship with user
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
