<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Loan extends Model
{
    use HasFactory;

    protected $fillable = [
        'date',
        'creditor_id',
        'debtor_id',
        'principle',
        'account_id',
        'rdate',
        'purpose',
        'intrest',
        'tamount',
        'installment',
        'next_installment_amount',
        'next_installment_date',
        'iamount',
        'paid',
        'status',
        'user_id',
        'location_id',
    ];

    # Creditor relation
    public function creditor()
    {
        return $this->belongsTo(Creditor::class);
    }

    # Debtor relation
    public function debtor()
    {
        return $this->belongsTo(debtor::class);
    }

    # User relation
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    # Account relation
    public function account()
    {
        return $this->belongsTo(Account::class);
    }

    # Location relation
    public function location()
    {
        return $this->belongsTo(Location::class);
    }
}
