<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Driver extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'address',
        'phone',
        'selling_id',
    ];

    # Load vehicle relation
    public function selling()
    {
        return $this->belongsTo(Selling::class);
    }

    # Load vehicle relation
    public function loadVehicle()
    {
        return $this->hasMany(LoadVehicle::class)->with('selling');
    }
}
