<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Debts extends Model
{
    use HasFactory;
    protected $fillable = [
        'date',
        'selling_id',
        'sale_id',
        'production_order_id',
        'customer_id',
        'account_id',
        'opening_balance',
        'amount',
        'discount',
        'paid',
        'due',
        
    ];

     # Selling relations.
    public function selling()
    {
        return $this->belongsTo(Selling::class);
    }

    // Account relations.
    public function account()
    {
        return $this->belongsTo(Account::class);
    }

    // Production order relations.
    public function productionOrder()
    {
        return $this->belongsTo(ProductionOrder::class);
    }

    // Sale relations.
    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }
    
    // Customer relations.
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
}
