<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustomerOrderItem extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'customer_order_id',
        'product',
        'buying_price',
        'selling_price',
        'qty',
    ];


    public function customerOrder()
    {
        return $this->belongsTo(CustomerOrder::class);
    }
}
