<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BusinessProfile extends Model
{
    use HasFactory;

    protected $fillable = [
        'selling_id',
        'exp_date',
        'device',
        'address',
        'phone',
        'email',
        'website',
        'tin',
        'vrn',
        'slogan',
        'logo',
        'vat',
        'receipt',
        'royalty',
        'royalty_discount',
        'batch_no',
        'qrcode'
    ];

    public function selling()
    {
        return $this->belongsTo(Selling::class, 'selling_id');
    }
}
