<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Account extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        "name",
        "type",
        "number",
        "balance",
        "selling_id",
    ];

    public function debts()
    {
        return $this->hasMany(Debts::class);
    }


    public function saleReturn()
    {
        return $this->hasMany(Account::class);
    }

     public function purchaseReturn()
    {
        return $this->hasMany(PurchaseReturn::class);
    }

    public function selling()
    {
        return $this->belongsTo(Selling::class, 'selling_id');
    }

    public function transaction()
    {
        return $this->hasMany(Transaction::class);
    }

    public function purchase()
    {
        return $this->hasMany(Purchase::class);
    }

    public function sale()
    {
        return $this->hasMany(Sale::class);
    }
}
