<?php

namespace App\Imports;

use App\Models\Account;
use App\Models\Product;
use App\Models\Sale;
use App\Models\SoldItem;
use App\Models\Stock;
use App\Models\StockMovement;
use App\Models\Transaction;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

class SalesImport implements ToCollection
{
    /**
     * @param Collection $collection
     */
    public function collection(Collection $rows)
    {
        // Initialize an array to store the sum for each date
        $dateSums = [];

        // Skip the first row
        $rows = $rows->skip(1);

        foreach ($rows as $row) {
            $date = $row[0];
            $amount = $row[4] * $row[5];

            // Check if the date already exists in the array, and add the amount to the sum
            if (isset($dateSums[$date])) {
                $dateSums[$date] += $amount;
            } else {
                $dateSums[$date] = $amount;
            }

            $saleData = Sale::where('date', $date)->first();
            if (!$saleData) {
                // Insert sale
                $saleData = new Sale();
                $saleData->user = auth()->user()->name;
                $saleData->date = $date;
                $saleData->location = $row[8];
                $saleData->account = $row[7];
                $saleData->status = "Cash";
            }

            // Update total, paid, and net with the sum
            $saleData->total = $dateSums[$date];
            $saleData->paid = $dateSums[$date];
            $saleData->net = $dateSums[$date];
            $saleData->save();

            // Get the account
            $accountData = Account::where("name", $row[7])
                ->where("selling_location", $row[8])
                ->first();

            // Insert transaction
            $transactionData = new Transaction();
            $transactionData->date = $date;
            $transactionData->reason = "Sale";
            $transactionData->status = "In";
            $transactionData->amount = $amount;
            $transactionData->before = $accountData->balance;
            $transactionData->after = $accountData->balance + $amount;
            $transactionData->account = $row[7];
            $transactionData->user = auth()->user()->name;
            $transactionData->selling_location = $row[8];
            $transactionData->save();

            // Update account balance
            $accountData->balance += $amount;
            $accountData->save();

            // Get product
            $productData = Product::where("product", $row[1])
                ->where("location", $row[8])
                ->first();

            // Insert sold item
            $itemData = new SoldItem();
            $itemData->sale_id = $saleData->id;
            $itemData->product = $row[1];
            $itemData->product_id = $productData->id;
            $itemData->unit = $row[2];
            $itemData->cont = $row[3];
            $itemData->price = $row[4];
            $itemData->qty = $row[5];
            $itemData->amount = $amount;
            $itemData->save();

            // Update stock balance
            $stockData = Stock::where("product", $row[1])
                ->where("location", $row[8])
                ->first();

            // Insert stock movement
            $movementData = new StockMovement();
            $movementData->user = auth()->user()->name;
            $movementData->date = $date;
            $movementData->product = $row[1];
            $movementData->reason = "Sale";
            $movementData->status = "Cash";
            $movementData->qty = $row[5];
            $movementData->before = $stockData->qty;
            $movementData->after = $stockData->qty - ($row[3] * $row[5]);
            $movementData->location = $row[8];
            $movementData->save();

            // Update stock balance table
            $stockData->qty -= $row[5];
            $stockData->save();
        }
    }
}
