<?php

namespace App\Imports;

use App\Models\DuplicateProduct;
use App\Models\Location;
use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\Stock;
use App\Models\Supplier;
use App\Models\Unit;
use App\Models\UnitAssigned;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ToCollection;

class ProductImport implements ToCollection
{
    /**
     * @param Collection $collection
     */
    public function collection(Collection $rows)
    {
        // # Begin a database transaction
        DB::beginTransaction();

        //   try {
        // Before the foreach loop, after DB::beginTransaction();
        // $supplier = Supplier::firstOrCreate(
        //     ['name' => 'HEKO PHARMACY LTD'],
        //     [
        //         'address' => 'Kkoo, Dar es salaam, Tanzania',
        //         'phone' => '0222181194',
        //         'email' => 'N/A',
        //         'vrn' => 'N/A',
        //         'tin' => 'N/A',
        //         'advance' => 0,
        //         'description' => 'Auto-created supplier from import',
        //         'opening_balance' => 0,
        //         'selling_id' => 1
        //     ]
        // );

        // $purchase = Purchase::create([
        //     'user_id' => auth()->id() ?? 1,
        //     'account_id' => 1,
        //     'supplier_id' => $supplier->id,
        //     'selling_id' => 1,
        //     'storage_id' => 1, // or location ID if known
        //     'date' => now()->toDateString(),
        //     'total' => 0, // will update after loop
        //     'discount' => 0,
        //     'net' => 0,
        //     'paid' => 0,
        //     'due' => 0,
        //     'invoice' => rand(1000, 9999),
        //     'status' => 'Paid',
        // ]);

        // $totalAmount = 0;

        //Skip the first row
        $rows = $rows->skip(1);
        foreach ($rows as $row) {
            $barcode = $row[0] != null ? $row[0] : str_pad(rand(0, 9999999999999), 13, '0', STR_PAD_LEFT);
            $product = ucwords($row[1]);
            $description = ucwords($row[25]);
            $category = ucwords($row[2]) ?? 1; // Default to category ID 1 if null
            $buying = $row[4];
            $supplier = ucwords($row[3]);
            $location = ucwords($row[23]);
            $minUnit = $row[17];
            $minCont = $row[18];
            $minQty  = $row[19];
            $qty = $row[20];
            $rawExp = $row[21]; // "03/27"
            $expNot  = $row[22];
            $unit1 =  $row[5];
            $cont1 =  $row[6];
            $sell1 =  $row[7];
            $unit2 =  $row[8];
            $cont2 =  $row[9];
            $sell2 =  $row[10];
            $unit3 =  $row[11];
            $cont3 =  $row[12];
            $sell3 =  $row[13];
            $unit4 =  $row[14];
            $cont4 =  $row[15];
            $sell4 =  $row[16];
            $batch_no = $row[24];

            // If value exists and matches month/year pattern
            if (!empty($rawExp) && preg_match('/^\d{2}\/\d{2}$/', $rawExp)) {
                [$month, $year] = explode('/', $rawExp);
                // Convert 2-digit year to 4-digit
                $year = strlen($year) == 2 ? '20' . $year : $year;
                // Format to date-month-year (assuming first day of month)
                $exp = sprintf("01-%02d-%04d", $month, $year);
            } else {
                $exp = null; // or keep original if needed
            }

            if ($category != "") {
                # Check if the category exists before creating a new entry.
                $existingCategory = ProductCategory::where("name", ucwords($category))->exists();

                if (!$existingCategory) {
                    $newCategory = new ProductCategory();
                    $newCategory->name = ucwords($category);
                    $newCategory->save();
                }
            }

            # Get the location & store it in a variable.
            $locationObject = Location::where("name", $location)->first();
            $categoryObject = ProductCategory::where("name", $category)->first(); // Get category from suppliers table.
            $supplierObject = Supplier::where("name", $supplier)->first(); // Get supplier from suppliers table.

            if (!$locationObject) {
                // skip this row if location doesn't exist
                continue;
            }

            $productCheck = Product::where("product", $product)
                ->where("location_id", $locationObject->id)
                ->first();

            if (!$productCheck) {
                # If the product doesn't exist, create it in the products table
                $newProduct = new Product();
                $newProduct->barcode = $barcode;
                $newProduct->product = $product;
                $newProduct->description = $description;
                $newProduct->buying = $buying;
                $newProduct->location_id = $locationObject->id;
                if ($supplierObject) {
                    $newProduct->supplier_id = $supplierObject->id;
                }
                if ($categoryObject) {
                    $newProduct->category_id = $categoryObject->id;
                }
                $newProduct->save();

                # Create units in the UnitAssigned table and check if they exist in the Unit table
                $units = [$unit1, $unit2, $unit3, $unit4];
                $conts = [$cont1, $cont2, $cont3, $cont4];
                $sells = [$sell1, $sell2, $sell3, $sell4];

                for ($x = 0; $x < count($units); $x++) {
                    # Check if the unit exists in units table before creating new e entry.
                    $existingUnit = Unit::where("name", ucwords($units[$x]))->exists();

                    if (!$existingUnit) {
                        $newUnit = new Unit();
                        $newUnit->name = ucwords($units[$x]);
                        $newUnit->save();
                    }

                    # Ignore each null unit.
                    if ($units[$x] != "") {
                        $unit = Unit::where("name", $units[$x])->first();
                        $assignedUnit = new UnitAssigned();
                        $assignedUnit->product_id = $newProduct->id;
                        $assignedUnit->unit_id = $unit->id;
                        $assignedUnit->unit_cont = $conts[$x];
                        $assignedUnit->selling = $sells[$x];
                        $assignedUnit->location_id = $locationObject->id;
                        $assignedUnit->save();
                    }
                }

                # Get each unit from units tables
                $unit_query = Unit::where("name", $minUnit)->first();

                # Create it in the stocks table
                $stock = new Stock();
                $stock->product_id = $newProduct->id;
                $stock->location_id = $locationObject->id;
                $stock->unit_id = $unit_query->id;
                $stock->min_cont = $minCont;
                $stock->min_qty = $minQty;
                $stock->qty = $qty;
                $stock->exp_date = $exp;
                $stock->exp_not = $expNot;
                $stock->batch_no = $batch_no;
                $stock->save();
            } else {
                # If the product doesn't exist, create it in the products table
                $newProduct = new Product();
                $newProduct->barcode = $barcode;
                $newProduct->product = strtoupper($product);
                $newProduct->buying = $buying;
                $newProduct->description = $description;
                $newProduct->location_id = $locationObject->id;
                if ($supplierObject) {
                    $newProduct->supplier_id = $supplierObject->id;
                }
                if ($categoryObject) {
                    $newProduct->category_id = $categoryObject->id;
                } else {
                    $newProduct->category_id = 3;
                }
                $newProduct->save();

                # Create units in the UnitAssigned table and check if they exist in the Unit table
                $units = [$unit1, $unit2, $unit3, $unit4];
                $conts = [$cont1, $cont2, $cont3, $cont4];
                $sells = [$sell1, $sell2, $sell3, $sell4];

                for ($x = 0; $x < count($units); $x++) {
                    // Skip optional empty units (unit 1 is required)
                    if ($x != 0 && empty($units[$x])) {
                        continue;
                    }

                    $unitName = ucwords($units[$x]);

                    $unit = Unit::firstOrCreate(['name' => $unitName]);

                    $assignedUnit = new UnitAssigned();
                    $assignedUnit->product_id = $newProduct->id;
                    $assignedUnit->unit_id = $unit->id;
                    $assignedUnit->unit_cont = $conts[$x] ?? 1; // Default to 1 if null
                    $assignedUnit->selling = $sells[$x] ?? 0;   // Default to 0 if null
                    $assignedUnit->location_id = $locationObject->id;
                    $assignedUnit->save();
                }

                # Get each unit from units tables
                $unit_query = Unit::where("name", $minUnit)->first();

                # Create it in the stocks table
                $stock = new Stock();
                $stock->product_id = $newProduct->id;
                $stock->location_id = $locationObject->id;
                $stock->unit_id = $unit_query->id;
                $stock->min_cont = $minCont;
                $stock->min_qty = $minQty;
                $stock->qty = $qty;
                $stock->exp_date = $exp;
                $stock->exp_not = $expNot;
                $stock->batch_no = $batch_no;
                $stock->save();
            }

            // Inside your foreach($rows as $row) loop, after creating $newProduct and $unit_query
            // $amount = $buying * $qty;
            // $totalAmount += $amount;

            // PurchasedItem::create([
            //     'purchase_id' => $purchase->id,
            //     'product_id' => $newProduct->id,
            //     'unit_id' => $unit_query->id,
            //     'cont' => $cont1,
            //     'buying' => $buying,
            //     'qty' => $qty,
            //     'amount' => $amount,
            //     'discount' => 0,
            //     'exp_date' => $exp,
            //     'batch_number' => $batch_no,
            // ]);
        }

        // After the foreach loop finishes:
        // $purchase->update([
        //     'total' => $totalAmount,
        //     'net' => $totalAmount,
        //     'paid' => $totalAmount,
        //     'due' => 0
        // ]);

        // Commit the transaction if all operations succeed
        DB::commit();
        // } catch (\Exception $e) {
        //     // Rollback the transaction if any exception occurs
        //     DB::rollBack();

        //     // Handle the exception (e.g., log error, display a message)
        //     return back()->with("error", "An error occurred while importing data.");
        // }
    }
}
