<?php

namespace App\Imports;

use App\Models\Ingredient;
use App\Models\Ingredients;
use App\Models\Location;
use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\Stock;
use App\Models\StockMovement;
use App\Models\Supplier;
use App\Models\Transaction;
use App\Models\Unit;
use App\Models\UnitAssigned;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\ToCollection;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class IngredientImport implements ToCollection
{
    /**
     * @param Collection $collection
     */

    public function collection(Collection $rows)
    {
        DB::beginTransaction();

        try {
            $index = 0;

            foreach ($rows as $row) {

                // Skip header row
                if ($index === 0) {
                    $index++;
                    continue;
                }

                $barcode     =  rand(100000, 999999);
                $productName = ucwords($row[0]);
                $subCategory = ucwords($row[1]);
                $buying      = $row[2];
                $minUnit     = $row[3];
                $qty         = $row[4];
                $minCont     = 1;
                $minQty      =  1;
                $exp         = $row[5] ?? null;
                $location    = ucwords($row[6]);

                // Fetch required relations
                $locationData = Location::where('name', $location)->first();
                $unitData = Unit::firstOrCreate(['name' => $minUnit]);

                $mainCategory = ProductCategory::where('name', 'Ingredient')->first();

                // Sub-category
                $subCategoryData = ProductCategory::where('name', $subCategory)->first();

                if (!$subCategoryData) {
                    $subCategoryData = ProductCategory::create([
                        'name'        => $subCategory,
                        'description' => 'Sub Category',
                        'parent_id'   => $mainCategory->id,
                    ]);
                }

                // Product
                $product = Product::create([
                    'barcode'     => $barcode ?: str_pad(rand(0, 9999999999999), 13, '0', STR_PAD_LEFT),
                    'product'     => $productName,
                    //  'image'       => $fileName ?? '',
                    'category_id' => $subCategoryData->id,
                    'buying'      => $buying,
                    'location_id' => $locationData->id,
                ]);

                // Stock
                $stock = Stock::create([
                    'product_id'  => $product->id,
                    'location_id' => $locationData->id,
                    'unit_id' => $unitData->id,
                    'min_qty'     => $minQty,
                    'qty'         => $qty,
                    'exp_date'    => $exp,
                ]);

                // Unit Assigned
                $unitAssigned = UnitAssigned::create([
                    'product_id'  => $product->id,
                    'unit_id'     => $unitData->id,
                    'unit_cont'   => $minCont,
                    'selling'     => 0,
                    'location_id' => $locationData->id,
                ]);

                // Stock movement
                recordStockMovement(
                    now()->format('Y-m-d'),
                    Auth::id(),
                    $product->id,
                    $locationData->id,
                    'Registered',
                    'In',
                    $qty
                );
            }

            DB::commit();
        } catch (\Throwable $e) {
            DB::rollBack();

            // Optional: log error
            Log::error('Excel Import Failed', [
                'error' => $e->getMessage()
            ]);

            throw $e; // Let Laravel handle the error
        }
    }
}
