<?php

namespace App\Imports;

use App\Models\Customer;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

class CustomerImport implements ToCollection
{
    /**
     * @param Collection $collection
     */
    public function collection(Collection $rows)
    { 
        $index = 0;
        # Loop through each row in the uploaded execl.
        foreach ($rows as $row) {
            # Skip the first row.
            if ($index == 0) {
                $index++;
                continue;
            }
            # Check if the customer exists.
            $customer_check = Customer::where("name", ucwords($row[0]))->exists();
            # If the customer doesn't exist create new entry.
            if ($customer_check == false) {
                $customer = new Customer();
                $customer->name =  ucwords($row[0]);
                $customer->phone =  ucwords($row[1]);
                $customer->address =  ucwords($row[2]);
                $customer->limit =  ucwords($row[3]);
                $customer->save();
            }
        }
    }
}
