<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class CheckLicenseValidity
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next)
    {
        $license = DB::table('licenses')->latest()->first();

        if (!$license) {
            abort(403, 'License data not found.');
        }

        $now = Carbon::now();
        $expiresAt = Carbon::parse($license->expires_at);
        $hExpiresAt = Carbon::parse($license->h_expires_at);

        if ($now->gt($expiresAt)) { # Check if the current time is after the license expires
            return redirect()->route('payment');
        }

        if ($now->gt($hExpiresAt)) { # Check if the current time is after the license expires
            return redirect()->route('payment');
        }
        return $next($request);
    }
}
