<?php

namespace App\Http\Controllers;

use App\Models\Waiter;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;

class WaitersController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
            # Get location details
            $locationDetails = processLocationDetails();
            $sellings = $locationDetails['sellings'];

            $waiters = Waiter::all();
            return view("waiters", compact("waiters", "sellings"));
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $request->validate([
                'name' => 'required|unique:waiters',
                'password' => 'required|unique:waiters',
            ]);

            $waiter = new Waiter();
            $waiter->name = ucwords($request->name);
            $waiter->address = ucwords($request->address);
            $waiter->phone = $request->phone;
            $waiter->password = $request->password;
            $waiter->selling_id = $request->location;
            $waiter->save();

            return back()->with("success", "Successfully added.");
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $waiter = Waiter::find($id);
            $waiter->name = ucwords($request->name);
            $waiter->address = ucwords($request->address);
            $waiter->phone = $request->phone;
            $waiter->password = $request->password;
            $waiter->selling_id = $request->location;
            $waiter->update();

            return back()->with("success", "Successfully updated");
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        try {
            $waiter = Waiter::find($request->id);

            if (!$waiter) {
                return response()->json([
                    'success' => false,
                    'message' => 'Waiter not found.',
                ]);
            }

            $waiter->delete();

            return response()->json([
                'success' => true,
                'message' => 'Successfully deleted!',
            ]);
        } catch (Exception $e) {
            Log::error($e->getMessage());

            return response()->json([
                'success' => false,
                'message' => 'Something went wrong.',
            ], 500);
        }
    }

    public function bulkDelete(Request $request)
    {
        try {
            $ids = $request->ids;

            if (!is_array($ids) || empty($ids)) {
                return response()->json(['error' => 'No valid IDs provided.'], 400);
            }

            $deletedIds = [];

            foreach ($ids as $id) {
                $waiter = Waiter::find($id);
                if ($waiter) {
                    $waiter->delete();
                    $deletedIds[] = $id;
                }
            }

            return response()->json([
                'success' => true,
                'deleted' => $deletedIds,
                'message' => count($deletedIds) . ' waiter(s) deleted successfully.'
            ]);
        } catch (\Exception $e) {
            Log::error('Bulk delete error: ' . $e->getMessage());
            return response()->json([
                'success' => false,
                'error' => 'Something went wrong during deletion.'
            ], 500);
        }
    }
}
