<?php

namespace App\Http\Controllers;

use App\Models\Account;
use App\Models\BusinessProfile;
use App\Models\Event;
use App\Models\Transaction;
use App\Models\Venue;
use App\Models\VenueBooking;
use Illuminate\Http\Request;

class VenueBookingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $events = Event::all();
        $venues = [];
        $date = "";

        # If the search button is clicked.
        if ($request->date !== "") {

            # Assign the selected date to date variable.
            $date = $request->date;

            # Get the free venue for the slected date.
            $venues = Venue::whereDate("date", "!=", $date)
                ->where("block", "==", "")
                ->get();
        }
        return view("venue-booking", compact("venues", "date", "events"));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        # Store the booking details in venue_bookings table.
        $booking = new VenueBooking();

        $booking->date = $request->date;
        $booking->customer = $request->customer;
        $booking->phone = $request->phone;
        $booking->start_time = $request->from;
        $booking->end_time = $request->to;
        $booking->comment = $request->comment;
        $booking->venue = $request->venue;
        $booking->pax = $request->pax;
        $booking->vprice = $request->vprice;
        $booking->event = $request->event;
        $booking->eprice = $request->eprice;
        $booking->total = $request->total;
        $booking->discount = $request->discount;
        $booking->net = $request->net;
        $booking->paid = $request->paid;
        $booking->account = $request->account;
        $booking->due = $request->due;
        $booking->status = $request->status;

        $booking->save();

        $current_booking = VenueBooking::find($booking->id);

        # Update status & date in the selected venue.
        $venue = Venue::where("name", $request->venue)->first();
        $venue->status = $request->status;
        $venue->date = $request->date;
        $venue->update();

        # Increament & Update the balance in the selected account.
        $account = Account::where("name", $request->account)->first();

        $transaction = new Transaction();

        $transaction->date = $request->date;
        $transaction->user = auth()->user()->name;
        $transaction->reason = "Venue payment";
        $transaction->status = "In";
        $transaction->amount = $request->net;
        $transaction->before = $account->balance;
        $transaction->after = $account->balance + $request->net;
        $transaction->account = $request->account;
        $transaction->selling_location = "Default shop";

        $transaction->save();

        $account->balance += $request->net;
        $account->update();

        $profile = BusinessProfile::select('name', 'address', 'phone', 'email', 'vat')->first();

        return view("venue-reciept", compact("current_booking", "profile"));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         VenueBooking::find($id)->delete();
        return back()->with("success", "Booking deleted");
    }
}
