<?php

namespace App\Http\Controllers;

use App\Models\Salesmen;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class SalesmenController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
            $salesmen = Salesmen::all();
            return view("salesmen", compact("salesmen"));
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'address' => 'nullable|string',
            'phone' => 'required|string',
        ]);

        DB::beginTransaction();

        try {
            $salesman = new Salesmen();
            $salesman->name = ucwords($request->name);
            $salesman->address = ucwords($request->address);
            $salesman->phone = $request->phone;
            $salesman->save();

            DB::commit();

            return back()->with("success", "Salesman successfully added!");
        } catch (Exception $e) {
            DB::rollBack();

            Log::error($e->getMessage());

            return back()->with('error', 'Something went wrong! Please try again.');
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string',
            'address' => 'nullable|string',
            'phone' => 'required|string',
        ]);

        DB::beginTransaction();

        try {
            $salesman = Salesmen::findOrFail($id);

            $salesman->name = ucwords($request->name);
            $salesman->address = ucwords($request->address);
            $salesman->phone = $request->phone;

            $salesman->save();

            DB::commit();

            return back()->with('success', 'Salesman successfully updated!');
        } catch (Exception $e) {
            DB::rollBack();
            Log::error($e->getMessage());

            return back()->with('error', 'Something went wrong! Please try again.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        DB::beginTransaction();

        try {
            $salesman = Salesmen::findOrFail($id);
            $salesman->delete();

            DB::commit();

            return back()->with('success', 'Salesman successfully deleted!');
        } catch (Exception $e) {
            DB::rollBack();
            Log::error($e->getMessage());

            return back()->with('error', 'Something went wrong! Please try again.');
        }
    }


    public function bulkDelete(Request $request)
    {
        try {
            $ids = $request->ids;
            $results = "";
            foreach ($ids as $id) {
                $results = Salesmen::find($id)->delete();
            }
            return response()->json($results);
        } catch (Exception $e) {
            // Log the error
            Log::error($e->getMessage());
            // Return a custom error response
            return response()->json(['error' => 'Something went wrong'], 500);
        }
    }
}
