<?php

namespace App\Http\Controllers;

use App\Models\Account;
use App\Models\Event;
use App\Models\Venue;
use App\Models\VenueBooking;
use Illuminate\Http\Request;

class EventsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $events = Event::all();
        return view("events", compact("events"));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        for ($i = 0; $i < count($request->name); $i++) {
            $event = new Event();
            $event->name = ucwords($request->name[$i]);
            $event->price = $request->price[$i];
            $event->save();
        }

        return back()->with("success", "Successfully added!!");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $event = Event::find($id);
        $event->name = ucwords($request->name);
        $event->price = $request->price;
        $event->update();

        return back()->with("success", "Successfully updated!!");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Event::find($id)->delete();
        return back()->with("success", "Successfully deleted!!");
    }

    public function bulkDelete(Request $request)
    {
        $ids = $request->ids;

        $results = "";

        foreach ($ids as $id) {
            $results = Event::find($id)->delete();
        }
        return response()->json($results);
    }

    public function eventPrice(Request $request)
    {
        $selected_event = $request->get("event");

        $event_price = Event::select("price")
            ->where("name", $selected_event)
            ->first();

        return response()->json($event_price);
    }

    public function upcomingEvents()
    {
        $current_date = date('Y-m-d');
        $accounts = Account::all();
        $events = Event::all();
        $venues = Venue::all();

        $bookings =  VenueBooking::where("status", "Booking")
            ->whereDate("date", ">", "$current_date")
            ->get();

        return view("upcoming-events", compact("bookings", "accounts", "events", "venues"));
    }
    public function inprogressEvents(){
        $current_date = date('Y-m-d');
        $accounts = Account::all();

        $bookings =  VenueBooking::where("status", "Checkin")
            ->whereDate("date", "=", "$current_date")
            ->get();

        return view("inprogress-events", compact("bookings", "accounts"));
    }
}
