<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\TableReservation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class TableReservationApiController extends Controller
{
    /**
     * Store a new reservation.
     */
    public function store(Request $request)
    {
        // Validate incoming request
        $validator = Validator::make($request->all(), [
            'table_id' => 'required|exists:tables,id',
            'customer_name' => 'required|string|max:255',
            'customer_phone' => 'nullable|string|max:20',
            'guest_count' => 'required|integer|min:1',
            'booking_start' => 'required|date',
            'booking_end' => 'nullable|date|after_or_equal:booking_start',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        // Create the reservation
        $reservation = TableReservation::create([
            'table_id' => $request->table_id,
            'customer_name' => $request->customer_name,
            'customer_phone' => $request->customer_phone,
            'guest_count' => $request->guest_count,
            'booking_start' => $request->booking_start,
            'booking_end' => $request->booking_end,
            'status' => 'booked', // Default status
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Reservation created successfully!',
            'data' => $reservation
        ], 201);
    }
}
