<?php

namespace App\Console\Commands;

use App\Models\Booking;
use App\Models\Room;
use App\Models\Sale;
use App\Models\SoldItem;
use Illuminate\Console\Command;

class SellRoom extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sell:room';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Auto sale the room eryday at 12:PM';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        # Get all rooms whose status is sold.
        $rooms = Room::where("status", "sold")->get();
        $roomCount = count($rooms);
        if ($roomCount > 0) {
            # Loop through the rooms
            foreach ($rooms as $room) {
                # Get booking details for each room & increment days column by 1.
                $bookingData = Booking::where("room_id", $room->id)->first();
                $bookingData->days += 1;
                $bookingData->total += $room->price;
                $bookingData->due = $bookingData->total - $bookingData->paid;
                $bookingData->update();

                # Post sale for that particular room.
                $sale = new Sale();
                $sale->user_id = $bookingData->user_id;
                $sale->date = date('Y-m-d');
                $sale->total = $room->price;
                $sale->net = $room->price;
                $sale->paid = 0;
                $sale->due = $room->price;
                $sale->room_id = $room->id;
                $sale->status = "credit";
                $sale->save();

                $item = new SoldItem();
                $item->sale_id = $sale->id;
                $item->unit_id = "Days";
                $item->cont = 1;
                $item->price = $room->price;
                $item->qty = 1;
                $item->amount = $room->price;
                $item->discount = 0;
                $item->save();
            }
        }

        return Command::SUCCESS;
    }
}
